<?php
date_default_timezone_set("America/New_York");
session_start();
error_reporting(E_ALL);
ini_set('display_errors', TRUE);
ini_set('display_startup_errors', TRUE);
include("config.inc.php");
include("db.inc.php");
include("../classes/Browser.php");
include("functions.inc.php");
$_SESSION['lang'] = 'en';
if( isset($_SESSION['lang']) ){
	// Include the language file
	include( HOMEPATH . "inc/lang/".$_SESSION['lang'].".inc.php");
}else{
	include( HOMEPATH . "inc/lang/en.inc.php");
}
$user_ip = getUserIP();
$td = date('Y-m-d');
$now = $td . ' ' . date("h:i:s");
$add_hour = strtotime( "$now + 1 hour");
$sess_exp = date('Y-m-d H:i:s', $add_hour);
$error = 0;

$request = new HttpRequest();
$request->setBaseUrl($murl);
$request->createRequest();

//echo $request->getControllerClassName(); // return controller name. Controller name separated by '-' is going to be converted to camel case.
$arr = ($request->getParameters());    // print all other parameters $_GET & $_POST
var_dump($arr);
echo "Size: " . count($arr) . "<br>";
$i = 0;
if( count($arr) > 0 ):
    foreach($arr as $key => $element) {
        $pg[] = $key;
        $target[] = $element;
    }
    var_dump($pg);
    var_dump($target);
else: $pg = "home";
endif;
//echo '-------------------------->SESSION: ' . $page . '/' . $cat;
/*========================================
  		 		LOGOUT
 ========================================*/
if( isset($_GET['logout']) && isset($_SESSION['login']) ){
	session_destroy();
	$log_res = $dbh1->prepare("INSERT INTO ".$db1_prefix."log (action, result, user_id, email, ip_address) VALUES ('logout', 'success', '".$_SESSION['user_id']."', '".$_SESSION['user_email']."', '$user_ip')");
	$log_res->execute();
	header("location: " . $murl);
}
/*========================================
  		 SESSION MANAGEMENT
 ========================================*/
if( !isset($_SESSION['login']) ){
	$visitor = 'guest';
}
if( !isset($_SESSION['visitor']) ){
	$_SESSION['visitor'] = $visitor . '-' . generateRandomString();
	$dbh1->query("INSERT INTO ".$db1_prefix."sessions (session, entry_url, ip_address, browser_client, start_time, expiry_time) VALUES ('" . $_SESSION['visitor'] . "', '$this_url', '$user_ip', '" . $browser->getBrowser() . "', '$now', '$sess_exp') ;");
}else{
	//echo $_SESSION['visitor'].'<br>';
	$sess = $dbh1->query("SELECT session, ip_address, start_time, expiry_time FROM ".$db1_prefix."sessions WHERE session = '" . $_SESSION['visitor'] . "';")->fetch();
	$curr_time = strtotime($now);
	$exp_time = strtotime($sess['expiry_time']);
	if( $curr_time > $exp_time ){
		//echo $curr_time . ' is greater than ' . $exp_time; 
		$dbh1->query("INSERT INTO ".$db1_prefix."sessions (session, entry_url, ip_address, browser_client, start_time, expiry_time) VALUES ('" . $_SESSION['visitor'] . "', '$this_url', '$user_ip', '" . $browser->getBrowser() . "', '$now', '$sess_exp') ;");
	}else{
		//echo $curr_time . ' is less than ' . $exp_time; 
	}
}
/*========================================
  		./ END SESSION MANAGEMENT
 ========================================*/

/*========================================
  		 ACCT LOGIN/RESET/SIGN UP
 ========================================*/
if( !isset($_GET['auth']) && isset($_SESSION['visitor']) && isset($_GET['page']) && $_GET['page'] == 'acct' && isset($_GET['asset']) && isset($_POST['request']) && ( isset($_POST[$field_prefix. 'birth']) && $_POST[$field_prefix. 'birth'] == '' ) ){
	$sess_res = $dbh1->query("SELECT * FROM ".$db1_prefix."sessions WHERE session = '" . $_GET['asset'] . "' && expiry_time < '" . strtotime($now) . "';")->fetch();
	switch( $_POST['request'] ){
		case 'login_request':
		/**************************
	     * LOGIN
	     * ***********************/
			$description = "Account Login";
			$email = $_POST[$field_prefix. 'email'];
			$usr = $dbh1->query("SELECT * FROM ".$db1_prefix."users WHERE primary_email = '$email';")->fetch();
			$hashed_password = $usr['password'];
			if(password_verify($_POST[$field_prefix. 'password'], $hashed_password)) {
				$msg = lang('WORD_WELCOME') . ' ' . $usr['first_name'] . ' ' . $usr['last_name'] . '. ' . lang('LOGIN_SUCCESS');
				$msg_alert = 'success';
				$_SESSION['login'] = $sess_login;
				$_SESSION['user_id'] = $usr['id'];
				$_SESSION['user_email'] = $email;
				$_SESSION['visitor'] = 'user-'.$usr['id'];
				$log_res = $dbh1->prepare("INSERT INTO ".$db1_prefix."log (action, result, user_id, email, ip_address) VALUES ('".$_POST['request']."', 'success', '".$usr['id']."', '$email', '$user_ip')");
				$log_res->execute();
			}else{
				$msg = lang('LOGIN_ERROR');
				$msg_alert = 'danger';
			}
			break;
		case 'signup_request':
			/********************************
				    Sign up processing
			*********************************/
			$description = "Account Sign Up";
			$src_url = $_POST['src_url'];
			// Check if the email already exists
			$email = $_POST[$field_prefix. 'email'];
			$acct_chk = $dbh1->prepare("SELECT primary_email FROM ".$db1_prefix."users WHERE primary_email = '$email';");
			$acct_chk->execute();
			$count = $acct_chk->rowCount();
			if( $count == 0 ){
				$fName = $_POST[$field_prefix. 'Fname'];
				$lName = $_POST[$field_prefix. 'Lname'];
				$pass = $_POST[$field_prefix. 'password'];
				$tcAgree = $_POST[$field_prefix. 'TCagree'];
				$hash = bin2hex(random_bytes(18));
				$hashed_password = password_hash($pass, PASSWORD_DEFAULT);
				$acct_res = $dbh1->prepare("INSERT INTO ".$db1_prefix."users (password, first_name, last_name, primary_email, hash, tc_agree, ip_address) VALUES ('$hashed_password', '$fName', '$lName', '$email', '$hash', '$tcAgree', '$user_ip')");
				$acct_res->execute();
				$count = $acct_res->rowCount();
				if( $count == 1 ){
					$log_res = $dbh1->prepare("INSERT INTO ".$db1_prefix."log (action, result, user_id, email, ip_address, hash) VALUES ('signup', 'pending', '', '$email', '$user_ip', '$hash')");
					$log_res->execute();
					// Send a confirmation email
					$email_type = 'confirmNewAccount';
					include( "mail-delivery-type.inc.php");
				}else{ 
					$msg = lang('NEW_ACCT_FAIL'); $msg_alert = 'danger'; 
				}
			}else{
				$error += 1;
				$msg = lang('EMAIL_EXISTS');
				$msg_alert = 'danger';
			}
			break;
		case 'reset_request':
			/********************************
				    Reset processing
			*********************************/
			$src_url = $_POST['src_url'];
			// Check if the email already exists
			$email = $_POST[$field_prefix. 'email'];
			$acct_chk = $dbh1->prepare("SELECT * FROM ".$db1_prefix."users WHERE primary_email = '$email';");
			$acct_chk->execute();
			$count = $acct_chk->rowCount();
			if( $count == 1 ){
				$user = $acct_chk->fetch();
				$fName = $user['first_name'];
				$lName = $user['last_name'];
				// 1. Check if this a duplicate request recently made and compare dates
				$log_check = $dbh1->query("SELECT * FROM ".$db1_prefix."log WHERE email = '$email' && action = 'password reset' ORDER BY timestamp DESC LIMIT 1; ")->fetch();
				$dayDiff = 0;
				$minDiff = 0;
				$secDiff = 0;
				if( !empty($log_check) ){
					$hash = $log_check['hash'];
					$dt1 = $log_check['timestamp'];
					$dt2 = $now;
					$datetime1 = new DateTime($dt1);
					$datetime2 = new DateTime($dt2);
					$interval = $datetime1->diff($datetime2);
					$dayDiff = $interval->format('%d');
					$minDiff = $interval->format('%i');
					$secDiff = $interval->format('%s');
					if( $secDiff < 15 ){
						$msg = lang('PASS_RESET_WAIT');
						$msg_alert = 'info';
					}else{
						$send_notification = 'ok';
					}
				} //. Time in seconds check
				// 2. Add a log entry with unique hash
				if( $dayDiff > 2 || empty($log_check) ){
					$hash = bin2hex(random_bytes(18));
					$log_res = $dbh1->prepare("INSERT INTO ".$db1_prefix."log (action, result, user_id, email, ip_address, hash) VALUES ('password reset', 'pending', '" . $user['id'] . "', '$email', '$user_ip', '$hash')");
					$log_res->execute();
					$send_notification = 'ok';
				}else{
					$log_sql = $dbh1->prepare("UPDATE ".$db1_prefix."log SET result = 'pending' WHERE hash = '$hash';");
					$log_sql->execute();
					$send_notification = 'ok';
				}
				// 3. Send an email with link to reset
				if( isset($send_notification) && $send_notification == 'ok' ){
					$msg = lang('PASS_RESET_CONFIRM');
				    $msg_alert = 'info';
					$email_type = 'confirmPassReset';
					include( "mail-delivery-type.inc.php");
				}
			}else{
				$msg = lang('EMAIL_NOT_FOUND');
				$msg_alert = 'danger';
			}
			$description = "Password Reset";
			break;
	}
}else{
	if( !isset($_SESSION['login']) ){
		$description = lang('REQUEST_NOT_RECOGNIZED');
		$error += 1;
		$msg = lang('LOGIN_ERROR');
		$msg_alert = 'danger';
	}
}
/*========================================
  		./ ACCT LOGIN/RESET/SIGN UP
 ========================================*/

/*========================================
  		 ACCT PASSWORD CONFIRMATION
 ========================================*/
if( (isset($_GET['page']) && $_GET['page'] == 'acct') && isset($_GET['reset']) && isset($_GET['auth']) ){	
	$description = lang('PASS_RESET_DESCRIPTION');
	$acct_chk = $dbh1->prepare("SELECT * FROM ".$db1_prefix."log WHERE hash = '".$_GET['auth']."';");
	$acct_chk->execute();
	$count = $acct_chk->rowCount();
	if( $count == 1 ){
		if( isset($_POST['setpass']) ){
			$log_sql = $dbh1->prepare("UPDATE ".$db1_prefix."log SET result = 'success' WHERE hash = '".$_GET['auth']."';");
			$log_sql->execute();
			$count = $log_sql->rowCount();
			if( $count == 1 ){
				$log = $acct_chk->fetch();
				$pass = $_POST[$field_prefix. 'newpass'];
				$hash = bin2hex(random_bytes(18));
				$hashed_password = password_hash($pass, PASSWORD_DEFAULT);
				$pass_sql = $dbh1->prepare("UPDATE ".$db1_prefix."users SET password = '" . $hashed_password . "', hash = '".$_GET['auth']."' WHERE id = '" . $log['user_id'] . "';");
				$pass_sql->execute();
				$execute_count = $pass_sql->rowCount();
				if( $execute_count == 1 ){
					$msg = lang('PASS_RESET_SUCCESS');
					$msg_alert = 'success';
				}
			}
		}else{
			$msg = lang('PASS_RESET_FORM');
			$msg_alert = 'info';
			$action = 'reset_password';
		}
	}else{
		$msg = lang('REQUEST_NOT_RECOGNIZED');
		$msg_alert = 'danger';
	}
	
}

/*========================================
  		 ACCT EMAIL CONFIRMATION
 ========================================*/
if( (isset($_GET['page']) && $_GET['page'] == 'acct') && isset($_GET['confirm']) && isset($_GET['auth']) ){
	$description = "Email Confirmation";
	// Check database for hash
	$acct_chk = $dbh1->prepare("SELECT * FROM ".$db1_prefix."users WHERE hash = '".$_GET['auth']."' && tc_agree = '0000-00-00 00:00:00';");
	$acct_chk->execute();
	$count = $acct_chk->rowCount();
	if( $count == 1 ){
		$log_sql = $dbh1->prepare("UPDATE ".$db1_prefix."log SET result = 'success' WHERE hash = '".$_GET['auth']."';");
		$log_sql->execute();
		// Update the user record
		$acct_set = $dbh1->prepare("UPDATE ".$db1_prefix."users SET tc_agree = '$now' WHERE hash = '".$_GET['auth']."';");
	  	$acct_set->execute();
		$count = $acct_set->rowCount();
		if( $count == 1 ){
			$msg = lang('EMAIL_CONFIRMED');
			$msg_alert = 'info';
		}
	}else{
		// Check if the hash exists and get email
		$email_chk = $dbh1->prepare("SELECT hash FROM ".$db1_prefix."users WHERE hash = '".$_GET['auth']."';");
		$email_chk->execute();
		$count = $email_chk->rowCount();
		if( $count == 1 ){
			$email = $dbh1->query("SELECT tc_agree FROM ".$db1_prefix."users WHERE hash = '".$_GET['auth']."';")->fetch();
			$datetime = new DateTime($email['tc_agree']);
			$date = $datetime->format('Y-m-d');
			$msg = lang('EMAIL_ALREADY_CONFIRMED') . date('D, M d, Y', strtotime($date));
			$msg_alert = 'info';
			
		}else{
			$msg = lang('EMAIL_NOT_FOUND');
			$msg_alert = 'danger';
		}
	}
	
}

//include( HOMEPATH . "assets/datetime/index.php");
?>