<?php
/*=================================================================

					OFFGRID ADVANCED SEARCH

===================================================================*/
?>
<div class="offcanvas offcanvas-end" tabindex="-1" id="filterOffcanvas" aria-labelledby="filterOffcanvas">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title" id="filterOffcanvasLabel"><?php echo lang('ADVANCED_SEARCH'); ?></h5>
    <button type="button" class="btn-close text-reset" data-coreui-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body">
    <div>
      <form>
		  <div class="form-floating mb-3 d-flex">
			<input type="search" name="q" class="form-control" id="floatingInput" placeholder="Search for Domains" required>
			<label for="floatingInput"><?php echo lang('SEARCH_DOMAINS'); ?></label>
		  </div>
		  <div class="mb-3">
  			<label for="MaxCharInput" class="form-label"><?php echo lang('MAX_CHARACTERS'); ?>: <output id="charOutputId">20</output></label>
			<input type="range" class="form-range" id="maxChar" value="20" min="1" max="100" oninput="charOutputId.value = maxChar.value">
		  </div>
		  <div class="form-check">
			  <input class="form-check-input" type="checkbox" value="" id="noHyphens">
			  <label class="form-check-label" for="noHyphens">
				<?php echo lang('EXCLUDE_HYPHENS'); ?>
			  </label>
		  </div>
		  <div class="form-check">
			  <input class="form-check-input" type="checkbox" value="" id="noNumbers">
			  <label class="form-check-label" for="noNumbers">
				<?php echo lang('EXCLUDE_NUMBERS'); ?>
			  </label>
		  </div>
		  <div class="form-check mb-3">
			  <input class="form-check-input" type="checkbox" value="" id="noSpecialChars">
			  <label class="form-check-label" for="noSpecialChars">
				<?php echo lang('EXCLUDE_SPECIAL_CHARACTERS'); ?>
			  </label>
		  </div>
		  <div class="row align-items-start">
			  <div class="col">
				<div class="form-floating mb-3 d-flex">
					<input type="number" name="minPrice" class="form-control" id="minPrice" placeholder="<?php echo lang('MIN_PRICE'); ?>">
					<label for="maxPrice"><?php echo lang('MIN_PRICE'); ?></label>
			    </div>
			  </div>
			  <div class="col">
				<div class="form-floating d-flex">
					<input type="number" name="maxPrice" class="form-control" id="maxPrice" placeholder="<?php echo lang('MAX_PRICE'); ?>">
					<label for="maxPrice"><?php echo lang('MAX_PRICE'); ?></label>
				</div>
			</div>  
		  </div>
		  <div class="form-floating mb-3 d-flex">
			<input type="text" name="startText" class="form-control" id="startText" placeholder="Starts with">
			<label for="startText"><?php echo lang('STARTS_WITH'); ?></label>
		  </div>
		  <div class="form-floating mb-3 d-flex">
			<input type="text" name="endText" class="form-control" id="endText" placeholder="Ends with">
			<label for="endText"><?php echo lang('ENDS_WITH'); ?></label>
		  </div>
		  <div class="form-floating mb-3 mt-4 d-flex"><h6><?php echo lang('DOMAIN_GROUPS'); ?></h6></div>
			  <div class="row align-items-start">
				  <div class="col">
					  <div class="form-check">
						  <input class="form-check-input" type="radio" value="" name="domainGroup" id="domainGroup0" checked>
						  <label class="form-check-label" for="domainGroup0">
							All
						  </label>
					  </div>
					  <div class="form-check">
						  <input class="form-check-input" type="radio" value="" name="domainGroup" id="domainGroup1">
						  <label class="form-check-label" for="domainGroup1">
							Curated / Exclusive
						  </label>
					  </div>
					  <div class="form-check">
						  <input class="form-check-input" type="radio" value="" name="domainGroup" id="domainGroup2">
						  <label class="form-check-label" for="domainGroup2">
							Sale / Reduced
						  </label>
					  </div>
				  </div>
				  <div class="col">
					 <div class="form-check">
						 <input class="form-check-input" type="radio" value="" name="domainGroup" id="domainGroup3">
						 <label class="form-check-label" for="domainGroup3">
							Premium
					  </label>
				     </div>
			      <div class="form-check">
					  <input class="form-check-input" type="radio" value="" name="domainGroup" id="domainGroup1">
					  <label class="form-check-label" for="domainGroup1">
						For Sale by Owner
					  </label>
				  </div>
				  <div class="form-check">
					  <input class="form-check-input" type="radio" value="" name="domainGroup" id="domainGroup2">
					  <label class="form-check-label" for="domainGroup2">
						Website Included
					  </label>
				  </div>
			  </div>
		  </div>
		  <div class="d-grid gap-0 mt-4">
			  <button class="btn btn-primary" type="submit">Search</button>
		  </div>
	  </form>
    </div>
  </div>
</div>
